/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.FastBlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.FrameSearching;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.IntBox;

public abstract class NetherPortalLikeForm
extends PortalGenForm {
    public final boolean generateFrameIfNotFound;

    public NetherPortalLikeForm(boolean generateFrameIfNotFound) {
        this.generateFrameIfNotFound = generateFrameIfNotFound;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, class_3218 fromWorld, class_2338 startingPos, class_3218 toWorld, @Nullable class_1297 triggeringEntity) {
        if (!NetherPortalGeneration.checkPortalGeneration(fromWorld, startingPos)) {
            return false;
        }
        Predicate<class_2680> areaPredicate = this.getAreaPredicate();
        Predicate<class_2680> thisSideFramePredicate = this.getThisSideFramePredicate();
        Predicate<class_2680> otherSideFramePredicate = this.getOtherSideFramePredicate();
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startingPos, areaPredicate, thisSideFramePredicate);
        if (fromShape == null) {
            return false;
        }
        if (!this.testThisSideShape(fromWorld, fromShape)) {
            return false;
        }
        if (NetherPortalGeneration.isOtherGenerationRunning(fromWorld, fromShape.innerAreaBox.getCenterVec())) {
            return false;
        }
        if (this.generateFrameIfNotFound) {
            for (class_2338 areaPos : fromShape.area) {
                fromWorld.method_8501(areaPos, class_2246.field_10124.method_9564());
            }
        }
        class_2338 toPos = cpg.mapPosition(fromShape.innerAreaBox.getCenter(), fromWorld, toWorld);
        FrameSearching.FrameSearchingFunc<PortalGenInfo> frameMatchingFunc = this.getFrameMatchingFunc(fromWorld, toWorld, fromShape);
        NetherPortalGeneration.startGeneratingPortal(fromWorld, toWorld, fromShape, toPos, IPGlobal.netherPortalFindingRadius, otherSideFramePredicate, toShape -> this.generateNewFrame(fromWorld, fromShape, toWorld, (BlockPortalShape)toShape), info -> {
            Portal[] result = this.generatePortalEntitiesAndPlaceholder((PortalGenInfo)info);
            cpg.onPortalsGenerated(result);
        }, () -> {
            if (!this.generateFrameIfNotFound) {
                return null;
            }
            return this.getNewPortalPlacement(toWorld, toPos, fromWorld, fromShape, triggeringEntity);
        }, () -> fromShape.frameAreaWithoutCorner.stream().allMatch(bp -> !fromWorld.method_22347(bp)), frameMatchingFunc);
        return true;
    }

    public FrameSearching.FrameSearchingFunc<PortalGenInfo> getFrameMatchingFunc(class_3218 fromWorld, class_3218 toWorld, BlockPortalShape fromShape) {
        Predicate<class_2680> areaPredicate = this.getAreaPredicate();
        Predicate<class_2680> otherSideFramePredicate = this.getOtherSideFramePredicate();
        FastBlockPortalShape fastFromShape = FastBlockPortalShape.fromBlockPortalShape(fromShape);
        return (blockAccess, x, y, z) -> {
            boolean matches = fastFromShape.matchShape(x, y, z, (px, py, pz) -> otherSideFramePredicate.test(blockAccess.getBlockState(px, py, pz)), (px, py, pz) -> areaPredicate.test(blockAccess.getBlockState(px, py, pz)));
            if (matches) {
                boolean matchToSelf;
                boolean bl = matchToSelf = fromWorld == toWorld && x == fastFromShape.basePosX() && y == fastFromShape.basePosY() && z == fastFromShape.basePosZ();
                if (!matchToSelf) {
                    FastBlockPortalShape moved = fastFromShape.withNewBase(x, y, z);
                    return new PortalGenInfo((class_5321<class_1937>)fromWorld.method_27983(), (class_5321<class_1937>)toWorld.method_27983(), fastFromShape.toBlockPortalShape(), moved.toBlockPortalShape());
                }
            }
            return null;
        };
    }

    @Nullable
    public PortalGenInfo getNewPortalPlacement(class_3218 toWorld, class_2338 toPos, class_3218 fromWorld, BlockPortalShape fromShape, @Nullable class_1297 triggeringEntity) {
        class_3222 player;
        boolean canForcePlace = false;
        if (triggeringEntity instanceof class_3222 && (player = (class_3222)triggeringEntity).method_7337()) {
            canForcePlace = true;
        }
        IntBox airCubePlacement = NetherPortalGeneration.findAirCubePlacement(toWorld, toPos, fromShape.axis, fromShape.totalAreaBox.getSize(), canForcePlace);
        if (!canForcePlace && airCubePlacement == null && triggeringEntity instanceof class_3222) {
            class_3222 player2 = (class_3222)triggeringEntity;
            player2.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.no_place_to_generate_portal"), false);
        }
        if (airCubePlacement == null) {
            return null;
        }
        BlockPortalShape placedShape = fromShape.getShapeWithMovedTotalAreaBox(airCubePlacement);
        return new PortalGenInfo((class_5321<class_1937>)fromWorld.method_27983(), (class_5321<class_1937>)toWorld.method_27983(), fromShape, placedShape);
    }

    public Portal[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        info.generatePlaceholderBlocks();
        return info.generateBiWayBiFacedPortal(GeneralBreakablePortal.ENTITY_TYPE);
    }

    public abstract void generateNewFrame(class_3218 var1, BlockPortalShape var2, class_3218 var3, BlockPortalShape var4);

    public abstract Predicate<class_2680> getOtherSideFramePredicate();

    public abstract Predicate<class_2680> getThisSideFramePredicate();

    public abstract Predicate<class_2680> getAreaPredicate();

    public boolean testThisSideShape(class_3218 fromWorld, BlockPortalShape fromShape) {
        return true;
    }
}

